/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.common.block.FramedBouncyCubeBlock;
import xfacthd.framedblocks.common.block.FramedButtonBlock;
import xfacthd.framedblocks.common.block.FramedChestBlock;
import xfacthd.framedblocks.common.block.FramedCollapsibleBlock;
import xfacthd.framedblocks.common.block.FramedCornerPillarBlock;
import xfacthd.framedblocks.common.block.FramedCornerSlopeBlock;
import xfacthd.framedblocks.common.block.FramedCube;
import xfacthd.framedblocks.common.block.FramedDoorBlock;
import xfacthd.framedblocks.common.block.FramedDoubleCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoublePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoublePrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlabBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedDoubleStairsBlock;
import xfacthd.framedblocks.common.block.FramedDoubleThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedElevatedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedExtendedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedFenceBlock;
import xfacthd.framedblocks.common.block.FramedFloorBlock;
import xfacthd.framedblocks.common.block.FramedFlowerPotBlock;
import xfacthd.framedblocks.common.block.FramedGateBlock;
import xfacthd.framedblocks.common.block.FramedHalfPillarBlock;
import xfacthd.framedblocks.common.block.FramedHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedHorizontalPaneBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedInverseDoubleSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedLadderBlock;
import xfacthd.framedblocks.common.block.FramedLargeButtonBlock;
import xfacthd.framedblocks.common.block.FramedLargeStoneButtonBlock;
import xfacthd.framedblocks.common.block.FramedLatticeBlock;
import xfacthd.framedblocks.common.block.FramedLeverBlock;
import xfacthd.framedblocks.common.block.FramedPaneBlock;
import xfacthd.framedblocks.common.block.FramedPanelBlock;
import xfacthd.framedblocks.common.block.FramedPillarBlock;
import xfacthd.framedblocks.common.block.FramedPressurePlateBlock;
import xfacthd.framedblocks.common.block.FramedPrismBlock;
import xfacthd.framedblocks.common.block.FramedPrismCornerBlock;
import xfacthd.framedblocks.common.block.FramedPyramidBlock;
import xfacthd.framedblocks.common.block.FramedRailSlopeBlock;
import xfacthd.framedblocks.common.block.FramedRedstoneBlock;
import xfacthd.framedblocks.common.block.FramedSignBlock;
import xfacthd.framedblocks.common.block.FramedSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlabCornerBlock;
import xfacthd.framedblocks.common.block.FramedSlabEdgeBlock;
import xfacthd.framedblocks.common.block.FramedSlopeBlock;
import xfacthd.framedblocks.common.block.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.block.FramedSlopeSlabBlock;
import xfacthd.framedblocks.common.block.FramedSlopedPrismBlock;
import xfacthd.framedblocks.common.block.FramedSoulTorchBlock;
import xfacthd.framedblocks.common.block.FramedSoulWallTorchBlock;
import xfacthd.framedblocks.common.block.FramedStairsBlock;
import xfacthd.framedblocks.common.block.FramedStoneButtonBlock;
import xfacthd.framedblocks.common.block.FramedStorageBlock;
import xfacthd.framedblocks.common.block.FramedTargetBlock;
import xfacthd.framedblocks.common.block.FramedThreewayCornerBlock;
import xfacthd.framedblocks.common.block.FramedTorchBlock;
import xfacthd.framedblocks.common.block.FramedTrapDoorBlock;
import xfacthd.framedblocks.common.block.FramedVerticalDoubleStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalHalfStairsBlock;
import xfacthd.framedblocks.common.block.FramedVerticalStairsBlock;
import xfacthd.framedblocks.common.block.FramedWallBlock;
import xfacthd.framedblocks.common.block.FramedWallBoardBlock;
import xfacthd.framedblocks.common.block.FramedWallSignBlock;
import xfacthd.framedblocks.common.block.FramedWallTorchBlock;
import xfacthd.framedblocks.common.block.FramedWeightedPressurePlateBlock;
import xfacthd.framedblocks.common.blockentity.FramedChestBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedCollapsibleBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleCornerBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoublePanelBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleSlabBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleSlopeBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleSlopePanelBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleSlopeSlabBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleStairsBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedDoubleThreewayCornerBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedFlowerPotBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedInverseDoubleSlopePanelBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedInverseDoubleSlopeSlabBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedSignBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedStorageBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedTargetBlockEntity;
import xfacthd.framedblocks.common.blockentity.FramedVerticalDoubleStairsBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.FramedToolType;
import xfacthd.framedblocks.common.item.FramedBlueprintItem;
import xfacthd.framedblocks.common.item.FramedToolItem;
import xfacthd.framedblocks.common.menu.FramedStorageMenu;

@Mod.EventBusSubscriber(modid="framedblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class FBContent {
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"framedblocks");
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"framedblocks");
    private static final DeferredRegister<BlockEntityType<?>> BE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"framedblocks");
    private static final DeferredRegister<MenuType<?>> CONTAINER_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"framedblocks");
    private static final Map<BlockType, RegistryObject<Block>> BLOCKS_BY_TYPE = new EnumMap<BlockType, RegistryObject<Block>>(BlockType.class);
    public static final RegistryObject<Block> blockFramedCube = FBContent.registerBlock(FramedCube::cube, BlockType.FRAMED_CUBE);
    public static final RegistryObject<Block> blockFramedSlope = FBContent.registerBlock(FramedSlopeBlock::new, BlockType.FRAMED_SLOPE);
    public static final RegistryObject<Block> blockFramedCornerSlope = FBContent.registerBlock(FramedCornerSlopeBlock::new, BlockType.FRAMED_CORNER_SLOPE);
    public static final RegistryObject<Block> blockFramedInnerCornerSlope = FBContent.registerBlock(FramedCornerSlopeBlock::new, BlockType.FRAMED_INNER_CORNER_SLOPE);
    public static final RegistryObject<Block> blockFramedPrismCorner = FBContent.registerBlock(FramedPrismCornerBlock::new, BlockType.FRAMED_PRISM_CORNER);
    public static final RegistryObject<Block> blockFramedInnerPrismCorner = FBContent.registerBlock(FramedPrismCornerBlock::new, BlockType.FRAMED_INNER_PRISM_CORNER);
    public static final RegistryObject<Block> blockFramedThreewayCorner = FBContent.registerBlock(FramedThreewayCornerBlock::new, BlockType.FRAMED_THREEWAY_CORNER);
    public static final RegistryObject<Block> blockFramedInnerThreewayCorner = FBContent.registerBlock(FramedThreewayCornerBlock::new, BlockType.FRAMED_INNER_THREEWAY_CORNER);
    public static final RegistryObject<Block> blockFramedSlab = FBContent.registerBlock(FramedSlabBlock::new, BlockType.FRAMED_SLAB);
    public static final RegistryObject<Block> blockFramedSlabEdge = FBContent.registerBlock(FramedSlabEdgeBlock::new, BlockType.FRAMED_SLAB_EDGE);
    public static final RegistryObject<Block> blockFramedSlabCorner = FBContent.registerBlock(FramedSlabCornerBlock::new, BlockType.FRAMED_SLAB_CORNER);
    public static final RegistryObject<Block> blockFramedPanel = FBContent.registerBlock(FramedPanelBlock::new, BlockType.FRAMED_PANEL);
    public static final RegistryObject<Block> blockFramedCornerPillar = FBContent.registerBlock(FramedCornerPillarBlock::new, BlockType.FRAMED_CORNER_PILLAR);
    public static final RegistryObject<Block> blockFramedStairs = FBContent.registerBlock(FramedStairsBlock::new, BlockType.FRAMED_STAIRS);
    public static final RegistryObject<Block> blockFramedWall = FBContent.registerBlock(FramedWallBlock::new, BlockType.FRAMED_WALL);
    public static final RegistryObject<Block> blockFramedFence = FBContent.registerBlock(FramedFenceBlock::new, BlockType.FRAMED_FENCE);
    public static final RegistryObject<Block> blockFramedGate = FBContent.registerBlock(FramedGateBlock::new, BlockType.FRAMED_GATE);
    public static final RegistryObject<Block> blockFramedDoor = FBContent.registerBlock(FramedDoorBlock::wood, BlockType.FRAMED_DOOR);
    public static final RegistryObject<Block> blockFramedIronDoor = FBContent.registerBlock(FramedDoorBlock::iron, BlockType.FRAMED_IRON_DOOR);
    public static final RegistryObject<Block> blockFramedTrapDoor = FBContent.registerBlock(FramedTrapDoorBlock::wood, BlockType.FRAMED_TRAPDOOR);
    public static final RegistryObject<Block> blockFramedIronTrapDoor = FBContent.registerBlock(FramedTrapDoorBlock::iron, BlockType.FRAMED_IRON_TRAPDOOR);
    public static final RegistryObject<Block> blockFramedPressurePlate = FBContent.registerBlock(FramedPressurePlateBlock::wood, BlockType.FRAMED_PRESSURE_PLATE);
    public static final RegistryObject<Block> blockFramedStonePressurePlate = FBContent.registerBlock(FramedPressurePlateBlock::stone, BlockType.FRAMED_STONE_PRESSURE_PLATE);
    public static final RegistryObject<Block> blockFramedObsidianPressurePlate = FBContent.registerBlock(FramedPressurePlateBlock::obsidian, BlockType.FRAMED_OBSIDIAN_PRESSURE_PLATE);
    public static final RegistryObject<Block> blockFramedGoldPressurePlate = FBContent.registerBlock(FramedWeightedPressurePlateBlock::gold, BlockType.FRAMED_GOLD_PRESSURE_PLATE);
    public static final RegistryObject<Block> blockFramedIronPressurePlate = FBContent.registerBlock(FramedWeightedPressurePlateBlock::iron, BlockType.FRAMED_IRON_PRESSURE_PLATE);
    public static final RegistryObject<Block> blockFramedLadder = FBContent.registerBlock(FramedLadderBlock::new, BlockType.FRAMED_LADDER);
    public static final RegistryObject<Block> blockFramedButton = FBContent.registerBlock(FramedButtonBlock::new, BlockType.FRAMED_BUTTON);
    public static final RegistryObject<Block> blockFramedStoneButton = FBContent.registerBlock(FramedStoneButtonBlock::new, BlockType.FRAMED_STONE_BUTTON);
    public static final RegistryObject<Block> blockFramedLever = FBContent.registerBlock(FramedLeverBlock::new, BlockType.FRAMED_LEVER);
    public static final RegistryObject<Block> blockFramedSign = FBContent.registerBlock(FramedSignBlock::new, BlockType.FRAMED_SIGN);
    public static final RegistryObject<Block> blockFramedWallSign = FBContent.registerBlock(FramedWallSignBlock::new, BlockType.FRAMED_WALL_SIGN);
    public static final RegistryObject<Block> blockFramedDoubleSlab = FBContent.registerBlock(FramedDoubleSlabBlock::new, BlockType.FRAMED_DOUBLE_SLAB);
    public static final RegistryObject<Block> blockFramedDoublePanel = FBContent.registerBlock(FramedDoublePanelBlock::new, BlockType.FRAMED_DOUBLE_PANEL);
    public static final RegistryObject<Block> blockFramedDoubleSlope = FBContent.registerBlock(FramedDoubleSlopeBlock::new, BlockType.FRAMED_DOUBLE_SLOPE);
    public static final RegistryObject<Block> blockFramedDoubleCorner = FBContent.registerBlock(FramedDoubleCornerBlock::new, BlockType.FRAMED_DOUBLE_CORNER);
    public static final RegistryObject<Block> blockFramedDoublePrismCorner = FBContent.registerBlock(FramedDoublePrismCornerBlock::new, BlockType.FRAMED_DOUBLE_PRISM_CORNER);
    public static final RegistryObject<Block> blockFramedDoubleThreewayCorner = FBContent.registerBlock(FramedDoubleThreewayCornerBlock::new, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER);
    public static final RegistryObject<Block> blockFramedTorch = FBContent.registerBlock(FramedTorchBlock::new, BlockType.FRAMED_TORCH);
    public static final RegistryObject<Block> blockFramedWallTorch = FBContent.registerBlock(FramedWallTorchBlock::new, BlockType.FRAMED_WALL_TORCH);
    public static final RegistryObject<Block> blockFramedSoulTorch = FBContent.registerBlock(FramedSoulTorchBlock::new, BlockType.FRAMED_SOUL_TORCH);
    public static final RegistryObject<Block> blockFramedSoulWallTorch = FBContent.registerBlock(FramedSoulWallTorchBlock::new, BlockType.FRAMED_SOUL_WALL_TORCH);
    public static final RegistryObject<Block> blockFramedFloor = FBContent.registerBlock(FramedFloorBlock::new, BlockType.FRAMED_FLOOR_BOARD);
    public static final RegistryObject<Block> blockFramedLattice = FBContent.registerBlock(FramedLatticeBlock::new, BlockType.FRAMED_LATTICE_BLOCK);
    public static final RegistryObject<Block> blockFramedVerticalStairs = FBContent.registerBlock(FramedVerticalStairsBlock::new, BlockType.FRAMED_VERTICAL_STAIRS);
    public static final RegistryObject<Block> blockFramedChest = FBContent.registerBlock(FramedChestBlock::new, BlockType.FRAMED_CHEST);
    public static final RegistryObject<Block> blockFramedBars = FBContent.registerBlock(FramedPaneBlock::new, BlockType.FRAMED_BARS);
    public static final RegistryObject<Block> blockFramedPane = FBContent.registerBlock(FramedPaneBlock::new, BlockType.FRAMED_PANE);
    public static final RegistryObject<Block> blockFramedRailSlope = FBContent.registerBlock(FramedRailSlopeBlock::new, BlockType.FRAMED_RAIL_SLOPE);
    public static final RegistryObject<Block> blockFramedFlowerPot = FBContent.registerBlock(FramedFlowerPotBlock::new, BlockType.FRAMED_FLOWER_POT);
    public static final RegistryObject<Block> blockFramedPillar = FBContent.registerBlock(FramedPillarBlock::new, BlockType.FRAMED_PILLAR);
    public static final RegistryObject<Block> blockFramedHalfPillar = FBContent.registerBlock(FramedHalfPillarBlock::new, BlockType.FRAMED_HALF_PILLAR);
    public static final RegistryObject<Block> blockFramedPost = FBContent.registerBlock(FramedPillarBlock::new, BlockType.FRAMED_POST);
    public static final RegistryObject<Block> blockFramedCollapsibleBlock = FBContent.registerBlock(FramedCollapsibleBlock::new, BlockType.FRAMED_COLLAPSIBLE_BLOCK);
    public static final RegistryObject<Block> blockFramedHalfStairs = FBContent.registerBlock(FramedHalfStairsBlock::new, BlockType.FRAMED_HALF_STAIRS);
    public static final RegistryObject<Block> blockFramedBouncyCube = FBContent.registerBlock(FramedBouncyCubeBlock::new, BlockType.FRAMED_BOUNCY_CUBE);
    public static final RegistryObject<Block> blockFramedSecretStorage = FBContent.registerBlock(FramedStorageBlock::new, BlockType.FRAMED_SECRET_STORAGE);
    public static final RegistryObject<Block> blockFramedRedstoneBlock = FBContent.registerBlock(FramedRedstoneBlock::new, BlockType.FRAMED_REDSTONE_BLOCK);
    public static final RegistryObject<Block> blockFramedPrism = FBContent.registerBlock(FramedPrismBlock::new, BlockType.FRAMED_PRISM);
    public static final RegistryObject<Block> blockFramedSlopedPrism = FBContent.registerBlock(FramedSlopedPrismBlock::new, BlockType.FRAMED_SLOPED_PRISM);
    public static final RegistryObject<Block> blockFramedSlopeSlab = FBContent.registerBlock(FramedSlopeSlabBlock::new, BlockType.FRAMED_SLOPE_SLAB);
    public static final RegistryObject<Block> blockFramedElevatedSlopeSlab = FBContent.registerBlock(FramedElevatedSlopeSlabBlock::new, BlockType.FRAMED_ELEVATED_SLOPE_SLAB);
    public static final RegistryObject<Block> blockFramedDoubleSlopeSlab = FBContent.registerBlock(FramedDoubleSlopeSlabBlock::new, BlockType.FRAMED_DOUBLE_SLOPE_SLAB);
    public static final RegistryObject<Block> blockFramedInverseDoubleSlopeSlab = FBContent.registerBlock(FramedInverseDoubleSlopeSlabBlock::new, BlockType.FRAMED_INV_DOUBLE_SLOPE_SLAB);
    public static final RegistryObject<Block> blockFramedVerticalHalfStairs = FBContent.registerBlock(FramedVerticalHalfStairsBlock::new, BlockType.FRAMED_VERTICAL_HALF_STAIRS);
    public static final RegistryObject<Block> blockFramedSlopePanel = FBContent.registerBlock(FramedSlopePanelBlock::new, BlockType.FRAMED_SLOPE_PANEL);
    public static final RegistryObject<Block> blockFramedExtendedSlopePanel = FBContent.registerBlock(FramedExtendedSlopePanelBlock::new, BlockType.FRAMED_EXTENDED_SLOPE_PANEL);
    public static final RegistryObject<Block> blockFramedDoubleSlopePanel = FBContent.registerBlock(FramedDoubleSlopePanelBlock::new, BlockType.FRAMED_DOUBLE_SLOPE_PANEL);
    public static final RegistryObject<Block> blockFramedInverseDoubleSlopePanel = FBContent.registerBlock(FramedInverseDoubleSlopePanelBlock::new, BlockType.FRAMED_INV_DOUBLE_SLOPE_PANEL);
    public static final RegistryObject<Block> blockFramedDoubleStairs = FBContent.registerBlock(FramedDoubleStairsBlock::new, BlockType.FRAMED_DOUBLE_STAIRS);
    public static final RegistryObject<Block> blockFramedVerticalDoubleStairs = FBContent.registerBlock(FramedVerticalDoubleStairsBlock::new, BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS);
    public static final RegistryObject<Block> blockFramedWallBoard = FBContent.registerBlock(FramedWallBoardBlock::new, BlockType.FRAMED_WALL_BOARD);
    public static final RegistryObject<Block> blockFramedGlowingCube = FBContent.registerBlock(FramedCube::glowingCube, BlockType.FRAMED_GLOWING_CUBE);
    public static final RegistryObject<Block> blockFramedPyramid = FBContent.registerBlock(FramedPyramidBlock::new, BlockType.FRAMED_PYRAMID);
    public static final RegistryObject<Block> blockFramedPyramidSlab = FBContent.registerBlock(FramedPyramidBlock::new, BlockType.FRAMED_PYRAMID_SLAB);
    public static final RegistryObject<Block> blockFramedLargeButton = FBContent.registerBlock(FramedLargeButtonBlock::new, BlockType.FRAMED_LARGE_BUTTON);
    public static final RegistryObject<Block> blockFramedLargeStoneButton = FBContent.registerBlock(FramedLargeStoneButtonBlock::new, BlockType.FRAMED_LARGE_STONE_BUTTON);
    public static final RegistryObject<Block> blockFramedHorizontalPane = FBContent.registerBlock(FramedHorizontalPaneBlock::new, BlockType.FRAMED_HORIZONTAL_PANE);
    public static final RegistryObject<Block> blockFramedTarget = FBContent.registerBlock(FramedTargetBlock::new, BlockType.FRAMED_TARGET);
    public static final RegistryObject<Item> itemFramedHammer = FBContent.registerToolItem(FramedToolItem::new, FramedToolType.HAMMER);
    public static final RegistryObject<Item> itemFramedWrench = FBContent.registerToolItem(FramedToolItem::new, FramedToolType.WRENCH);
    public static final RegistryObject<Item> itemFramedBlueprint = FBContent.registerToolItem(FramedBlueprintItem::new, FramedToolType.BLUEPRINT);
    public static final RegistryObject<Item> itemFramedKey = FBContent.registerToolItem(FramedToolItem::new, FramedToolType.KEY);
    public static final RegistryObject<Item> itemFramedScrewdriver = FBContent.registerToolItem(FramedToolItem::new, FramedToolType.SCREWDRIVER);
    public static final RegistryObject<BlockEntityType<FramedBlockEntity>> blockEntityTypeFramedBlock = FBContent.createBlockEntityType(FramedBlockEntity::new, "framed_tile", FBContent.getDefaultEntityBlocks());
    public static final RegistryObject<BlockEntityType<FramedSignBlockEntity>> blockEntityTypeFramedSign = FBContent.createBlockEntityType(FramedSignBlockEntity::new, BlockType.FRAMED_SIGN, BlockType.FRAMED_WALL_SIGN);
    public static final RegistryObject<BlockEntityType<FramedDoubleSlabBlockEntity>> blockEntityTypeDoubleFramedSlab = FBContent.createBlockEntityType(FramedDoubleSlabBlockEntity::new, BlockType.FRAMED_DOUBLE_SLAB);
    public static final RegistryObject<BlockEntityType<FramedDoublePanelBlockEntity>> blockEntityTypeDoubleFramedPanel = FBContent.createBlockEntityType(FramedDoublePanelBlockEntity::new, BlockType.FRAMED_DOUBLE_PANEL);
    public static final RegistryObject<BlockEntityType<FramedDoubleSlopeBlockEntity>> blockEntityTypeDoubleFramedSlope = FBContent.createBlockEntityType(FramedDoubleSlopeBlockEntity::new, BlockType.FRAMED_DOUBLE_SLOPE);
    public static final RegistryObject<BlockEntityType<FramedDoubleCornerBlockEntity>> blockEntityTypeDoubleFramedCorner = FBContent.createBlockEntityType(FramedDoubleCornerBlockEntity::new, BlockType.FRAMED_DOUBLE_CORNER);
    public static final RegistryObject<BlockEntityType<FramedDoubleThreewayCornerBlockEntity>> blockEntityTypeDoubleFramedThreewayCorner = FBContent.createBlockEntityType(FramedDoubleThreewayCornerBlockEntity::new, BlockType.FRAMED_DOUBLE_THREEWAY_CORNER, BlockType.FRAMED_DOUBLE_PRISM_CORNER);
    public static final RegistryObject<BlockEntityType<FramedChestBlockEntity>> blockEntityTypeFramedChest = FBContent.createBlockEntityType(FramedChestBlockEntity::new, BlockType.FRAMED_CHEST);
    public static final RegistryObject<BlockEntityType<FramedFlowerPotBlockEntity>> blockEntityTypeFramedFlowerPot = FBContent.createBlockEntityType(FramedFlowerPotBlockEntity::new, BlockType.FRAMED_FLOWER_POT);
    public static final RegistryObject<BlockEntityType<FramedCollapsibleBlockEntity>> blockEntityTypeFramedCollapsibleBlock = FBContent.createBlockEntityType(FramedCollapsibleBlockEntity::new, BlockType.FRAMED_COLLAPSIBLE_BLOCK);
    public static final RegistryObject<BlockEntityType<FramedStorageBlockEntity>> blockEntityTypeFramedSecretStorage = FBContent.createBlockEntityType(FramedStorageBlockEntity::new, BlockType.FRAMED_SECRET_STORAGE);
    public static final RegistryObject<BlockEntityType<FramedDoubleSlopeSlabBlockEntity>> blockEntityTypeFramedDoubleSlopeSlab = FBContent.createBlockEntityType(FramedDoubleSlopeSlabBlockEntity::new, BlockType.FRAMED_DOUBLE_SLOPE_SLAB);
    public static final RegistryObject<BlockEntityType<FramedInverseDoubleSlopeSlabBlockEntity>> blockEntityTypeFramedInverseDoubleSlopeSlab = FBContent.createBlockEntityType(FramedInverseDoubleSlopeSlabBlockEntity::new, "framed_inverse_double_slope_slab", () -> new Block[]{(Block)blockFramedInverseDoubleSlopeSlab.get()});
    public static final RegistryObject<BlockEntityType<FramedDoubleSlopePanelBlockEntity>> blockEntityTypeFramedDoubleSlopePanel = FBContent.createBlockEntityType(FramedDoubleSlopePanelBlockEntity::new, BlockType.FRAMED_DOUBLE_SLOPE_PANEL);
    public static final RegistryObject<BlockEntityType<FramedInverseDoubleSlopePanelBlockEntity>> blockEntityTypeFramedInverseDoubleSlopePanel = FBContent.createBlockEntityType(FramedInverseDoubleSlopePanelBlockEntity::new, "framed_inverse_double_slope_panel", () -> new Block[]{(Block)blockFramedInverseDoubleSlopePanel.get()});
    public static final RegistryObject<BlockEntityType<FramedDoubleStairsBlockEntity>> blockEntityTypeFramedDoubleStairs = FBContent.createBlockEntityType(FramedDoubleStairsBlockEntity::new, BlockType.FRAMED_DOUBLE_STAIRS);
    public static final RegistryObject<BlockEntityType<FramedVerticalDoubleStairsBlockEntity>> blockEntityTypeFramedVerticalDoubleStairs = FBContent.createBlockEntityType(FramedVerticalDoubleStairsBlockEntity::new, BlockType.FRAMED_VERTICAL_DOUBLE_STAIRS);
    public static final RegistryObject<BlockEntityType<FramedTargetBlockEntity>> blockEntityTypeFramedTarget = FBContent.createBlockEntityType(FramedTargetBlockEntity::new, BlockType.FRAMED_TARGET);
    public static final RegistryObject<MenuType<FramedStorageMenu>> menuTypeFramedStorage = FBContent.createMenuType(FramedStorageMenu::new, "framed_chest");

    public static void init() {
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BE_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
        CONTAINER_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static Collection<RegistryObject<Block>> getRegisteredBlocks() {
        return BLOCKS.getEntries();
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).map(IFramedBlock.class::cast).filter(block -> block.getBlockType().hasBlockItem()).map(IFramedBlock::createItemBlock).forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
    }

    private static Supplier<Block[]> getDefaultEntityBlocks() {
        return () -> (Block[])BLOCKS.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof IFramedBlock).map(IFramedBlock.class::cast).filter(block -> !block.getBlockType().hasSpecialTile()).toArray(Block[]::new);
    }

    private static <T extends Block> RegistryObject<Block> registerBlock(Function<BlockType, T> blockFactory, BlockType type) {
        return FBContent.registerBlock(() -> (Block)blockFactory.apply(type), type);
    }

    private static <T extends Block> RegistryObject<Block> registerBlock(Supplier<T> blockFactory, BlockType type) {
        RegistryObject result = BLOCKS.register(type.getName(), () -> {
            Block block = (Block)blockFactory.get();
            Preconditions.checkArgument((((IFramedBlock)block).getBlockType() == type ? 1 : 0) != 0);
            return block;
        });
        BLOCKS_BY_TYPE.put(type, (RegistryObject<Block>)result);
        return result;
    }

    private static RegistryObject<Item> registerToolItem(Function<FramedToolType, Item> itemFactory, FramedToolType type) {
        return ITEMS.register(type.getName(), () -> (Item)itemFactory.apply(type));
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createBlockEntityType(BlockEntityType.BlockEntitySupplier<T> factory, BlockType ... types) {
        Supplier<Block[]> blocks = () -> (Block[])Arrays.stream(types).map(BLOCKS_BY_TYPE::get).map(RegistryObject::get).toArray(Block[]::new);
        return FBContent.createBlockEntityType(factory, types[0].getName(), blocks);
    }

    private static <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createBlockEntityType(BlockEntityType.BlockEntitySupplier<T> factory, String name, Supplier<Block[]> blocks) {
        return BE_TYPES.register(name, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)factory, (Block[])((Block[])blocks.get())).m_58966_(null));
    }

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> createMenuType(IContainerFactory<T> factory, String name) {
        return CONTAINER_TYPES.register(name, () -> IForgeMenuType.create((IContainerFactory)factory));
    }

    private FBContent() {
    }
}

